#!/bin/csh
#
# Generation of the input file for trove energies
#

setenv nprocs 4

setenv OMP_NUM_THREADS $nprocs

set fname = xseq-T-$1.dat
echo $fname
#
cat<<endb> $fname.inp

mem 8 gb

Range  0.  16000
Npoints    16001

temperature $1

absorption (emission)

nuPQR
hwhm 60
offset 1000
enermax 40000
threshold 1e-60
enercut 40000

nram 1000000

nprocs $nprocs

output  $fname

States s-v_C2H2.dat

Transitions
  p_$1_v12.dat
  p_$1_v9.dat
  p_$1_v7.dat
  t-vib.dat
end

verbose 3


endb

./ExoCross_3band.x < $fname.inp  > $fname.out
