/*-----------------------------------------------------------------*/
/*! 
  \file cmset.c 
  \brief Check that functions fail normally

  \author  G. Boue
           EXOEarths, Centro de Astrofisica, Universidade do Porto.

   Copyright (C) 2012, CAUP
   email of the author : gwenael.boue@astro.up.pt

   This work has been supported by the European Research Council/European
   Community under the FP7 through Starting Grant agreement number 239953, as
   well as from Fundacao para a Ciencia e a Tecnologia (FCT) through program
   Ciencia 2007 funded by FCT/MCTES (Portugal) and POPH/FSE (EC), and in the
   form of grants reference PTDC/CTE-AST/098528/2008, SFRH/BPD/71230/2010, and
   SFRH/BPD/81084/2011.


  History:                                                                
*/
/*-----------------------------------------------------------------*/

/*----------------------------------------------------------------*/
/* License of the file :

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
/*----------------------------------------------------------------*/
#include <stdio.h>
#include <stdlib.h>
#include "arome.h"


/*************************/
/* main routine          */
/* just a test           */
/*************************/
int main(int argc, char **argv)
{
   double x;
   t_arome *parome = NULL;
   int status = 0;
   
   if (arome_set_lineprofile(3.0,10.0,8.0,0.0,4,parome) == 0)
   {
     fprintf(stderr, "arome_set_lineprofile should have failed.\n");
     exit(EXIT_FAILURE);
   }
   
   if (arome_set_planet(0.1,parome) == 0)
   {
     fprintf(stderr, "arome_set_planet should have failed.\n");
     exit(EXIT_FAILURE);
   }
   
   /* allocation of the ARoME structure */
   parome = arome_alloc_quad(0.6,0.0);
   
   if (arome_init_CCF(parome) == 0)
   {
     fprintf(stderr, "arome_init_CCF should have failed.\n");
     exit(EXIT_FAILURE);
   }
   
   if (arome_init_iodine(parome) == 0)
   {
     fprintf(stderr, "arome_init_iodine should have failed.\n");
     exit(EXIT_FAILURE);
   }
   
   if (arome_calc_fvpbetap(0.0,0.0,1.0,parome) == 0)
   {
     fprintf(stderr, "arome_calc_fvpbetap should have failed.\n");
     exit(EXIT_FAILURE);
   }
   
   if (arome_set_lineprofile(3.0,10.0,8.0,0.0,4,parome) != 0)
   {
      exit(EXIT_FAILURE);
   }
   
   if (arome_set_planet(0.1,parome) != 0)
   {
      exit(EXIT_FAILURE);
   }
   
   x = arome_get_flux(parome);
   if (x == x)
   {
     fprintf(stderr, "arome_get_flux should have failed.\n");
     exit(EXIT_FAILURE);
   }
   
   x = arome_get_vp(parome);
   if (x == x)
   {
     fprintf(stderr, "arome_get_vp should have failed.\n");
     exit(EXIT_FAILURE);
   }
   
   x = arome_get_betapR(parome);
   if (x == x)
   {
     fprintf(stderr, "arome_get_betapR should have failed.\n");
     exit(EXIT_FAILURE);
   }
   
   x = arome_get_betapT(parome);
   if (x == x)
   {
     fprintf(stderr, "arome_get_betapT should have failed.\n");
     exit(EXIT_FAILURE);
   }
   
   /* release memory */
   arome_free(parome);
   
   return status;
}
