!/*-----------------------------------------------------------------*/
!/*! 
!  \file f2003orbit.f 
!  \brief Example of usage of the ARoME library using the Fortran 2003 interface
!         This example computes planet coordinates from elliptic elements
!
!  \author  G. Boue
!           EXOEarths, Centro de Astrofisica, Universidade do Porto.
!
!   Copyright (C) 2012, CAUP
!   email of the author : gwenael.boue@astro.up.pt
!
!   This work has been supported by the European Research Council/European
!   Community under the FP7 through Starting Grant agreement number 239953, as
!   well as from Fundacao para a Ciencia e a Tecnologia (FCT) through program
!   Ciencia 2007 funded by FCT/MCTES (Portugal) and POPH/FSE (EC), and in the
!   form of grants reference PTDC/CTE-AST/098528/2008, SFRH/BPD/71230/2010, and
!   SFRH/BPD/81084/2011.
!
!
!  History:                                                                
!*/
!/*-----------------------------------------------------------------*/

!/*----------------------------------------------------------------*/
!/* License of the file :
!
!    This program is free software: you can redistribute it and/or modify
!    it under the terms of the GNU General Public License as published by
!    the Free Software Foundation, either version 3 of the License, or
!    (at your option) any later version.
!
!    This program is distributed in the hope that it will be useful,
!    but WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!    GNU General Public License for more details.
!
!    You should have received a copy of the GNU General Public License
!    along with this program.  If not, see <http://www.gnu.org/licenses/>.
!*/
!/*----------------------------------------------------------------*/


       program main
       use module_arome

       implicit none
       integer, parameter :: n = 11
       real(8)      :: per, sma, ecc, inc, om, lambda
       real(8)      :: ttransit, x, y, z
       real(8)      :: tab_t(n), tab_x(n), tab_y(n), tab_z(n)
       integer      :: nerror
       integer      :: k
       type(C_PTR)  :: orbit1

       !/* orbital parameters */
       per = 2.d0        !/* orbital period (day) */
       sma = 4.d0        !/* semi-major axis in Rs */
       ecc = 0.02d0      !/* eccentricity */
       inc = 82.8d0      !/* inclination (deg) */
       om  = 32.d0       !/* arg. of periastron (deg) */
       lambda = 21.d0    !/* projected spin-orbit angle (deg) */

       !/* never exit on error */
       call arome_set_continue_on_error()

       !/* creation of a new orbit */
       orbit1 = arome_new_orbit()

       !/* set the elliptic parameters */
       nerror = arome_set_orbit_eo(per,sma,ecc,om,inc,lambda,orbit1)

       !/* compute the time of transit */
       ttransit = arome_get_orbit_transit_time(orbit1)

       !/* compute one planet position */
       nerror = arome_get_orbit_xyz(orbit1, ttransit, x, y, z)

       !/* array of time (+-2h around transit) */
       do k=1,n
         tab_t(k) = (k-1-floor(n/2.d0))/((n-1.d0)*6.d0)+ttransit
       end do

       !/* compute multiple planet positions for the same orbit */
       nerror = arome_mget_orbit_xyz(orbit1,tab_t,n,tab_x,tab_y,tab_z)

       !/* release memory */
       call arome_free_orbit(orbit1)


       print *, "------------------------------"
       print *, "Coordinates of the planet ...."
       print *, "------------------------------"
       print *, "time = ", ttransit
       print *, "x    = ", x
       print *, "y    = ", y
       print *, "z    = ", z
       print *, "------------------------------"
       print *, ""

       print *, "------------------------------"
       print '(A23,A23,A23,A23)', "time", "x coordinate",               &
     &        "y coordinate", "z coordinate"

       do k=1,n
         print '(SP,E23.15,E23.15,E23.15,E23.15)',                      &
     &         tab_t(k), tab_x(k), tab_y(k), tab_z(k)
       end do

       end program main
