;------------------------------------------------------------------------------;
function SpectraPrep, phr
;------------------------------------------------------------------------------;
	common specdata, npb, nvp, phase, dphase, vp, spi, sp, spri, spr, spf, sprf
;------------------------------------------------------------------------------;
	; nr of phase points over phase range
	npr = npb * phr
	phaser = [phase, phase + (phr - 1)]
	; resolution factor: nr of pixels per average phase bin
	rf = 7
	; max nr of phase points in plot
	npm = 1000
	; average delta phase
	adp = total(dphase) / npb
	np0 = fix(2 * rf / adp)
	npp = min([npm, np0])
	; input spectra array
	spf = fltarr(npp, nvp)
	; reconstructed spectra array
	if spri gt 0 then sprf = spf
	n0 = intarr(npr)
	n1 = n0
	nct = intarr(npp)
;------------------------------------------------------------------------------;
	; fold phase bins into image
	for i = 0, npr - 1 do begin
		i0 = i mod npb
		phf0 = phaser(i) - dphase(i0) / 2
		phf1 = phaser(i) + dphase(i0) / 2
		n0(i) = max([0, fix(npp * phf0 / phr + 0.5)])
		n1(i) = min([npp - 1, fix(npp * phf1 / phr + 0.5)])
		; fold input and reconstructed spectra
		for j = n0(i), n1(i) do begin
			; input spectra
			spf(j, *) = spf(j, *) + sp(i0, *)
			; reconstructed spectra
			if spri gt 0 then sprf(j, *) = sprf(j, *) + spr(i0, *)
			nct(j) = nct(j) + 1
		endfor
	endfor
	for i = 0, npp - 1 do begin
		if nct(i) ne 0 then begin
			spf(i, *) = spf(i, *) / nct(i)
			if spri gt 0 then sprf(i, *) = sprf(i, *) / nct(i)
		endif else begin
			spf(i, *) = 0
			if spri gt 0 then sprf(i, *) = 0
		endelse
	endfor
;------------------------------------------------------------------------------;
	return, 0
end
;------------------------------------------------------------------------------;
