;------------------------------------------------------------------------------;
function DopMapPlot, pos, vxy, map0, truecol
;------------------------------------------------------------------------------;
	; define dopmap area
	!x.range = [min(vxy), max(vxy)]
	!y.range = [min(vxy), max(vxy)]
	plot, vxy, vxy, position = pos, xstyle = 5, ystyle = 5, /noerase, /nodata
	xsi = !x.window(1) - !x.window(0)
	ysi = !y.window(1) - !y.window(0)
	; display dopmap
	if truecol eq 0 then begin
		tv, map0, !x.window(0), !y.window(0), xsize = xsi, ysize = ysi, /norm
	endif else begin
		tv, map0, true = truecol
	endelse
	; add velocity coordinate grid
	result = VGridPlot(pos)
	if result ne 0 then return, 1
;------------------------------------------------------------------------------;
	return, 0
end
;------------------------------------------------------------------------------;
