;------------------------------------------------------------------------------;
function DopMapAxAv, mapin
;------------------------------------------------------------------------------;
; calculate axisymmetric average part of dopmap
;------------------------------------------------------------------------------;
	common mapdata, np, mapi, map, dmapi, dmap
;------------------------------------------------------------------------------;
	if n_elements(mapin) ne 0 then map = mapin
	npp = sqrt(2) * np / 2 + 1
	r = findgen(npp) + (1 - (np mod 2)) * 0.5
	indx = intarr(npp, 20 * npp)
	indy = indx
	inm = intarr(npp)
	inv = intarr(np, np)
	for i = 0, np - 1 do begin
		x = i - np / 2. + 0.5
		for j = 0, np - 1 do begin
			y = j - np / 2. + 0.5
			rr = sqrt(x^2 + y^2)
			k = npp - 1
			while r(k) gt rr do k = k - 1
			if rr - r(k) gt 0.5 then kp = k + 1 else kp = k
			ip = inm(kp)
			;print, i, j, x, y, rr, kp, ip
			indx(kp, ip) = i
			indy(kp, ip) = j
			inv(i, j) = kp
			inm(kp) = inm(kp) + 1
		endfor
	endfor
	s = fltarr(npp)
	for k = 0, npp - 1 do begin
		s(k) = 0
		for ip = 0, inm(k) - 1 do s(k) = s(k) + map(indx(k, ip), indy(k, ip))
		if inm(k) ne 0 then s(k) = s(k) / inm(k)
	endfor
	mapav = fltarr(np, np)
	for i = 0, np - 1 do begin
		for j = 0, np - 1 do mapav(i, j) = s(inv(i, j))
	endfor
	;tvscl, map
	;tvscl, mapav, 1
	;tvscl, map - mapav, 2
;------------------------------------------------------------------------------;
	return, mapav
end
;------------------------------------------------------------------------------;
