;------------------------------------------------------------------------------;
pro ColorBarPlot, sdir = sdir, eps = eps, psc = psc, ctb = ctb, rte = rte, $
	suf = suf, lbl = lbl
;------------------------------------------------------------------------------;
; plot color bar for specified color table
;------------------------------------------------------------------------------;
; sdir	:	map source directory; default ''
; eps	:	output encapsulated postscript; default 1 (yes)
; psc	:	output postscript in color; default 1 (yes)
; ctb	:	color table; default 15 (stern-special)
; rte	:	color bar rotation (0, 1, 2 or 3); default 0
; suf	:	output file suffix; default ''
; lbl	:	label indicator (0=none, 1=min-max, 2=0.0-0.25-0.50-0.75-1.0)
;------------------------------------------------------------------------------;
	; check keywords, set defaults
	if n_elements(sdir) eq 0 then sdir = ''
	if n_elements(eps) eq 0 then eps = 1
	if n_elements(psc) eq 0 then psc = 1
	if n_elements(ctb) eq 0 then ctb = 15
	if n_elements(rte) eq 0 then rte = 1
	if n_elements(suf) eq 0 then suf = ''
	if n_elements(lbl) eq 0 then lbl = 0
;------------------------------------------------------------------------------;
;	; add Coyote Library to IDL path
;	!PATH = Expand_Path('+~/.idl/coyote/') + ':' + !PATH
;------------------------------------------------------------------------------;
	; set plotting to postscript
	set_plot, 'ps'
	; set up device
	device, font_size = 12, bits_per_pixel = 8
	; set encapsulated postscript if necessary
	if eps eq 1 then device, /encaps else device, encaps = 0
	; set color postscript if necessary
	if psc eq 1 then device, /color else device, color = 0
	; load default color table
	loadct, ctb, /silent
	; max no of colors of display
	mcol = !d.table_size - 1
;------------------------------------------------------------------------------;
	; increase plot definition
	!p.thick = 3
	!p.charthick = 3
	!p.charsize = 1.25
	!x.charsize = 1
	!y.charsize = 1
;------------------------------------------------------------------------------;

;------------------------------------------------------------------------------;
	; set up device for map color bar output
	device, /portrait, xsize = 15, ysize = 15
	; separate ps file for colorbar
	file = sdir + 'colorbar' + suf + '.ps'
	device, filename = file
	; offsets, sizes, ranges and ticks
	xof = 0.125
	yof = 0.125
	if (rte eq 0) or (rte eq 2) then begin
		xsi = 0.75
		ysi = 0.025
		xra = [0, 1]
		yra = [0, 0]
		xtc = 4
		ytc = 1
		xtl = 0.25
		ytl = 0.0
	endif else begin
		xsi = 0.025
		ysi = 0.75
		xra = [0, 0]
		yra = [0, 1]
		xtc = 1
		ytc = 4
		xtl = 0.0
		ytl = 0.25
	endelse
	; create colorbar
	cbar = Bindgen(256) # Replicate(1B, 10)
	cbar = BytScl(cbar, Top = 255)
	pos = [xof, yof, xof + xsi, yof + ysi]
	tv, rotate(cbar, rte), pos(0), pos(1), xsize = pos(2) - pos(0), $
		ysize = pos(3) - pos(1), /norm
	plots, [pos(0), pos(0), pos(2), pos(2), pos(0)], $
		[pos(1), pos(3), pos(3), pos(1), pos(1)], /norm
	plot, [0,1], [0,1], position = pos, xrange = xra, yrange = yra, $
		xstyle = 1, ystyle = 1, xticks = xtc, yticks = ytc, $
			xminor = 0, yminor = 0, xticklen = xtl, yticklen = ytl, $
				xtickformat = '(A1)', ytickformat = '(A1)', $
					charsize = 0.8, /nodata, /noerase
	; labels
	if lbl gt 0 then begin
		if (rte eq 0) or (rte eq 2) then begin
			pos0 = [pos(0) - 0.0200, pos(1) - 0.0200]
			pos1 = [pos(0) + 0.1675, pos(1) - 0.0200]
			pos2 = [pos(0) + 0.3575, pos(1) - 0.0200]
			pos3 = [pos(2) - 0.2075, pos(1) - 0.0200]
			pos4 = [pos(2) - 0.0200, pos(1) - 0.0200]
		endif else begin
			pos0 = [pos(2) + 0.0075, pos(1) - 0.0050]
			pos1 = [pos(2) + 0.0075, pos(1) + 0.1825]
			pos2 = [pos(2) + 0.0075, pos(1) + 0.3700]
			pos3 = [pos(2) + 0.0075, pos(3) - 0.1950]
			pos4 = [pos(2) + 0.0075, pos(3) - 0.0050]
		endelse
		if lbl eq 1 then lab = ['min', '', '', '', 'max']
		if lbl eq 2 then lab = ['0.00', '0.25', '0.50', '0.75', '1.00']
		
		xyouts, pos0(0), pos0(1), lab(0), chars = 0.8, /norm
		xyouts, pos1(0), pos1(1), lab(1), chars = 0.8, /norm
		xyouts, pos2(0), pos2(1), lab(2), chars = 0.8, /norm
		xyouts, pos3(0), pos3(1), lab(3), chars = 0.8, /norm
		xyouts, pos4(0), pos4(1), lab(4), chars = 0.8, /norm

	endif
	device, /close
	if eps eq 1 then spawn, "sed -i '$ i\showpage' " + file
;------------------------------------------------------------------------------;
	return
end
;------------------------------------------------------------------------------;
