;------------------------------------------------------------------------------;
pro AvgProfPlot, inf = inf, ttl = ttl, xtl = xtl, ytl = ytl, vsf = vsf, $
	chs = chs, ovr = ovr
;------------------------------------------------------------------------------;
	; line profile averaged over phase
;------------------------------------------------------------------------------;
	common pardata, vm, vf, gam, w0, abs, atm, src, ih, nrm, ns, wd, am, al, ac
;------------------------------------------------------------------------------;
	common specdata, npb, nvp, phase, dphase, vp, spi, sp, spri, spr, spf, sprf
;------------------------------------------------------------------------------;
	if n_elements(sp) eq 0 then DopTomogRead, inf
;	w0s = string(format = '(f8.1)', w0)
	w0s = string(format = '(i5)', w0) + '!3'+STRING(197B)+'!X'
;------------------------------------------------------------------------------;
	if n_elements(ttl) eq 0 then ttl = 'Phase averaged line profile:' + w0s
	if n_elements(xtl) eq 0 then xtl = 'Radial velocity !5v!Dr!N !5[10!E3!N!5 km s!E-1!N!5]'
	if n_elements(ytl) eq 0 then ytl = 'Arbitrary flux' ;'F!D!7m!5!N'
	if n_elements(vsf) eq 0 then vsf = 10.0^(float(fix(alog10(vm))))
	if n_elements(chs) eq 0 then chs = 1.25
	if n_elements(ovr) eq 0 then ovr = 1
;------------------------------------------------------------------------------;
	vpa = vp / vsf
	xm = vpa(nvp - 1)
	flux = total(sp, 1) / npb
	fm = max(flux)
	fluxr = total(spr, 1) / npb
	fmr = max(fluxr)
	ym = 1.025 * fm
	if fmr gt fm then ym = 1.025 * fmr
	pos = [0.10, 0.10, 0.95, 0.90]
	; plot phase averaged line profile
	plot, vpa, flux, position = pos, title = ttl, chars = chs, $
		/noerase, xtit = xtl, xra = [-xm, xm], xstyle = 1, $
			ytit = ytl, yra = [0, ym], ystyle = 1, ytickformat = "(A1)"
	if ovr eq 1 then oplot, vpa, fluxr, line = 1
;------------------------------------------------------------------------------;
	return
end
;------------------------------------------------------------------------------;
