#!/bin/bash
################################################################################
# remember: chmod 755 7-gnu.binarymodel.sh
################################################################################
# write gnuplot version to temporary file
gnuplot --version > gnuplotVersion
# parse version from file
read sDum sVer sDum sPatch < gnuplotVersion
# remove temporary file
rm gnuplotVersion
# validate version
v4=4
vpt4=4
vpt6=6
if (( ${sVer%%.*} != $v4 || ( ${sVer##*.} != $vpt4 && ${sVer##*.} != $vpt6 ) )) ; then
	echo " >:( $sVer is an invalid gnuplot version!"
	source $scpdir/shell/continue.sh 1
	exit
fi
################################################################################
# default plotting parameters
x0=0.0 # x-origin
y0=0.0 # y-origin
if (( ${sVer%%.*} == $v4 && ${sVer##*.} == $vpt4 )) ; then
	x0=0.0 # x-origin
	y0=0.525 # y-origin
fi
sc=3.5	# scale
rS=1.0	# radius of primary scale factor
cI=0	# centre of mass indicator (0 = system, 1 = primary)
eS=0	# exclude secondary (0 = no, 1 = yes)
dA=0	# display axes (0 = no, 1 = yes)
sS=1	# if sS = 1 skip user input
################################################################################
# set parent directory
prtdir=$(pwd)
# set code directory
cdedir=$prtdir/code
# set script directory
scpdir=$prtdir/scripts
# set sources directory
srcdir=$prtdir/sources
################################################################################
# user input
# get source folder name
result=1
while [ $result -eq 1 ]; do
	read -p "Source folder name (e.g., mcv, etc.)? "
	if [ ! -z "$REPLY" ]; then
		# call validatedir.sh to check if source folder exists
		source $scpdir/shell/validatedir.sh $srcdir $REPLY 1
		result=$?
	fi
done
# set source
src=$REPLY
# set source folder path
srcfldr=$srcdir/$src
################################################################################
# call validatedir.sh to check if binarymodel output folder exists
source $scpdir/shell/validatedir.sh $srcfldr/out/binarymodel/ gnu 1
if [ "$?" -eq 1 ]; then exit; fi
################################################################################
# get plotting terminal
declare -a terms=(["1"]=1 ["2"]=1 ["3"]=1 ["9"]=1)
result=1
while [ $result -eq 1 ]; do
	read -p "Plotting terminal (1 = ps, 2 = eps, 3 = png, 9 = wxt [screen])? "
	if [[ ${terms[$REPLY]} ]]; then
		result=0
	else
		echo " >:( Invalid terminal... try again!"
	fi
done
# set plotting terminal
trm=$REPLY
################################################################################
# go to gnu script folder...
cd $scpdir/gnu
# process model script
# set source path
srcpath=$srcfldr/in/
# set binarymodel source path
modpath=$srcfldr/out/binarymodel/gnu/
# execute gnuplot script
echo "executing 'binarymodel3d.plt' in GNUPlot..."
# plotting parameters
pp="terminal=$trm; scale=$sc; x0=$x0; y0=$y0; comInd=$cI; exSec=$eS; dAxes=$dA; "
# paths and file name
pf="modpath='$modpath'; srcpath='$srcpath'; file='binarymodel3d'; sVer=$sVer"
gnuplot -e "$pp$pf" binarymodel3d.plt
# display output for ps
if [ "$trm" == "1" ]; then
	read -p "Display output (y/n)? "
	if [[ "$REPLY" =~ ^(y|yes|Y|YES|Yes)$ ]]; then
		gnome-open $modpath/binarymodel3d.ps &
	fi
fi
################################################################################
# back to parent directory
cd $prtdir
################################################################################
# continue (exit)
source $scpdir/shell/continue.sh 1
################################################################################
