#!/bin/bash
################################################################################
# remember: chmod 755 5-exec.pbinarymodel.sh
################################################################################
# set parent directory
prtdir=$(pwd)
# set code directory
cdedir=$prtdir/code
# set script directory
scpdir=$prtdir/scripts
# set sources directory
srcdir=$prtdir/sources
################################################################################
# first things first...
# go to code directory
cd $cdedir
# compile pbinarymodel (if necessary)
make pbinarymodel
################################################################################
# get source folder name
result=1
while [ $result -eq 1 ]; do
	read -p "Source folder name (e.g., mcv, etc.)? "
	if [ ! -z "$REPLY" ]; then
		# call validatedir.sh to check if source folder exists
		source $scpdir/shell/validatedir.sh $srcdir $REPLY 1
		result=$?
	fi
done
# set source
src=$REPLY
# set source folder path
srcfldr=$srcdir/$src
################################################################################
# output directory
# call makedir.sh to make binarymodel output folders if necessary
source $scpdir/shell/makedir.sh $srcfldr out 0
source $scpdir/shell/makedir.sh $srcfldr/out binarymodel 0
source $scpdir/shell/makedir.sh $srcfldr/out/binarymodel gnu 0
source $scpdir/shell/makedir.sh $srcfldr/out/binarymodel idl 0
################################################################################
# call validatefile.sh to check if 'binarymodel.in' exists in 'srcfldr'/in
source $scpdir/shell/validatefile.sh $srcfldr/in binarymodel.in 1
if [ "$?" -eq 1 ]; then exit; fi
################################################################################
# process binary model
# set input path
inpath=$srcfldr/in/
# loop for idl and gnu
for ((h=0; h<=1; h++))
do
	if [ $h -eq 0 ]; then ext="gnu"; fi
	if [ $h -eq 1 ]; then ext="idl"; fi
	# set output path
	outpath=$srcfldr/out/binarymodel/$ext/
	# execute binarymodel in 'codedir' folder
	echo "executing 'binarymodel ($ext)' for $src..."
	./pbinarymodel $h $inpath $outpath
done
################################################################################
# cleanup
# call removedir.sh to remove binarymodel output folders if necessary
source $scpdir/shell/removedir.sh $srcfldr/out/binarymodel/gnu
source $scpdir/shell/removedir.sh $srcfldr/out/binarymodel/idl
source $scpdir/shell/removedir.sh $srcfldr/out/binarymodel
################################################################################
# back to parent directory
cd $prtdir
################################################################################
# continue (exit)
source $scpdir/shell/continue.sh 1
################################################################################
