#!/bin/bash
################################################################################
# remember: chmod 755 3_execute.pdoptomog.sh
################################################################################
# set parent directory
prtdir=$(pwd)
# set code directory
cdedir=$prtdir/code
# set script directory
scpdir=$prtdir/scripts
# set sources directory
srcdir=$prtdir/sources
################################################################################
# first things first...
# go to code directory
cd $cdedir
# compile pdoptomog (if necessary)
make pdoptomog
################################################################################
# get source folder name
result=1
while [ $result -eq 1 ]; do
	read -p "Source folder name (e.g., mcv, etc.)? "
	if [ ! -z "$REPLY" ]; then
		# call validatedir.sh to check if source folder exists
		source $scpdir/shell/validatedir.sh $srcdir $REPLY 1
		result=$?
	fi
done
# set source
src=$REPLY
# set source folder path
srcfldr=$srcdir/$src
################################################################################
# output directory
# call validatedir.sh to check if spectra output folder exists
source $scpdir/shell/validatedir.sh $srcfldr/out spectra 1
if [ "$?" -eq 1 ]; then exit; fi
# call makedir.sh to make doptomog output folder if necessary
source $scpdir/shell/makedir.sh $srcfldr/out doptomog 0
################################################################################
# call validatefile.sh to check if 'doptomog.in' exists in 'srcfldr'/in
source $scpdir/shell/validatefile.sh $srcfldr/in doptomog.in 1
if [ "$?" -eq 1 ]; then exit; fi
################################################################################
# process spectra for doppler tomography
# set doptomog source path
outfldr=$srcfldr/out/doptomog
# loop for standard and inside-out projections
for ((i=0; i<=1; i++))
do
	if [ $i -eq 0 ]; then mth="standard"; fi
	if [ $i -eq 1 ]; then mth="inside-out"; fi
	read -p "Execute pdoptomog for $src $mth projection (y/n)? "
	if [[ "$REPLY" =~ ^(y|yes|Y|YES|Yes)$ ]]; then
		# execute doptomog in 'codedir' folder
		echo "executing pdoptomog for $src $mth projection..."
		./pdoptomog $i $srcfldr/
		# check if half-phases where calculated
		source $scpdir/shell/validatefile.sh $outfldr halfphases.$i.out 0
		if [ "$?" -eq 0 ]; then
			# make halfphases folder (if necessary)
			source $scpdir/shell/makedir.sh $outfldr halfphases 0
			# move halfphases files to halfphases folder
			# get nr of halfphases files
			n=$(head -n 1 $outfldr/halfphases.$i.out)-1
			for ((k=0; k<=$n; k++))
			do
				# move halfphases file
				mv $outfldr/doptomog.$i.$k.out $outfldr/halfphases/doptomog.$i.$k.out
			done
			mv $outfldr/halfphases.$i.out $outfldr/halfphases/halfphases.$i.out
		fi
		# check if flux modulation mapping was done
		source $scpdir/shell/validatefile.sh $outfldr fluxmodmap.$i.out 0
		if [ "$?" -eq 0 ]; then
			# make fluxmodmap folder (if necessary)
			source $scpdir/shell/makedir.sh $outfldr fluxmodmap 0
			# move fluxmodmap file to fluxmodmap folder
			mv $outfldr/fluxmodmap.$i.out $outfldr/fluxmodmap/fluxmodmap.$i.out
		fi
	fi
done
################################################################################
# cleanup
# call removedir.sh to remove doptomog output folder if necessary
source $scpdir/shell/removedir.sh $srcfldr/out doptomog
################################################################################
# back to parent directory
cd $prtdir
################################################################################
# continue (exit)
source $scpdir/shell/continue.sh 1
################################################################################
