#!/bin/bash
################################################################################
# remember: chmod 755 2-exec.pspectra.extract.sh
################################################################################
# set parent directory
prtdir=$(pwd)
# set code directory
cdedir=$prtdir/code
# set script directory
scpdir=$prtdir/scripts
# set sources directory
srcdir=$prtdir/sources
################################################################################
# first things first...
# go to code directory
cd $cdedir
# compile pspectra (if necessary)
make pspectra
################################################################################
# get source folder name
result=1
while [ $result -eq 1 ]; do
	read -p "Source folder name (e.g., mcv, etc.)? "
	if [ ! -z "$REPLY" ]; then
		# call validatedir.sh to check if source folder exists
		source $scpdir/shell/validatedir.sh $srcdir $REPLY 1
		result=$?
	fi
done
# set source
src=$REPLY
# set source folder path
srcfldr=$srcdir/$src
################################################################################
# output directory
# call validatedir.sh to check if spectra output folder exists
source $scpdir/shell/validatedir.sh $srcfldr/out spectra 1
if [ "$?" -eq 1 ]; then exit; fi
################################################################################
# call validatefile.sh to check if 'specextract.in' exists in 'srcfldr'/in
source $scpdir/shell/validatefile.sh $srcfldr/in specextract.in 1
if [ "$?" -eq 1 ]; then exit; fi
################################################################################
# process spectra
# set type of process (1 = extract)
stype=1
# execute spectra in 'codedir' folder
echo "executing 'pspectra (extract)' for $src..."
./pspectra $stype $srcfldr/
################################################################################
# cleanup
# call removedir.sh to remove spectra output folder if necessary
source $scpdir/shell/removedir.sh $srcfldr/out spectra
################################################################################
# back to parent directory
cd $prtdir
################################################################################
# continue (exit)
source $scpdir/shell/continue.sh 1
################################################################################
