/*------------------------------------------------------------------------------
NAME
	lidar.h - include file for programs accessing lidar data files
 
DESCRIPTION
	'lidar.h' contains definitions and declarations used by programs that
	read the lidar FITS data format.
   
REVISION
	100919	P. Hickson

COPYRIGHT
	Copyright (c) 2010 by P. Hickson. No part of this program may be copied or 
	released to a third party without written permission.
------------------------------------------------------------------------------*/
// Definitions
#define	STRSIZE			1024		// size of generic string buffer
#define MAXCOUNT		10000		// maximum number of photons per shot
#define NCHANNELS		4			// number of detector channels
#define NSHOTS			50			// number of shots per FITS record
#define	DT				0.020		// seconds between shots
#define M_PER_NS		0.149896229	// range per ns of travel time
#define FITS_HDR_SIZ	2880		// number of bytes in FITS header
#define FITS_BLOCK_SIZ	2880		// size of a FITS block
#define MAX_SEQ_NO		99			// maximum number of FITS files per night

// Declarations and type definitions
typedef struct FITS {
	char
		recvr[70],					// receiver type
		config[70],					// lidar configuration
		bloc[70];					// beam location for first shot
	int	naxis,						// should be 1
		bitpix,						// should be 16
		naxis1,						// number of photons in this record
		year,						// UTC year (eg 2010)
		mon,						// UTC mon (1-12)
		day,						// UTC day (1-31)
		hour,						// UTC hour (0-23)
		min,						// UTC min (0-59)
		sec,						// UTC sec of first shot (0-59)
		nbin0,						// number of bins in first sequence
		bsize0,						// bin size for first sequence (ns)
		bstart0,					// start time for first sequence (ns)
		nbin1,						// number of bins in second sequence
		bsize1,						// bin size for second sequence (ns)
		bstart1,					// start time for first sequence (ns)
		count[NSHOTS];				// number of photons in each shot
	double
		alt,						// telescope altitude (m)
		lat,						// telescope latitude (deg N)
		lon,						// telescope longitude (deg E)
		bangle,						// beam azimuth angle for first shot (deg)
		power,						// beam mean power (W)
		wave;						// beam wavelength (nm)
} Fits;

// Function prototypes
int 
	read_fits_header(char*,Fits*);

