!/*-----------------------------------------------------------------*/
!/*! 
!  \file f2003multiple.f
!  \brief Check the function arome_mset_flux
!
!  \author  G. Boue
!           EXOEarths, Centro de Astrofisica, Universidade do Porto.
!
!   Copyright (C) 2012, CAUP
!   email of the author : gwenael.boue@astro.up.pt
!
!   This work has been supported by the European Research Council/European
!   Community under the FP7 through Starting Grant agreement number 239953, as
!   well as from Fundacao para a Ciencia e a Tecnologia (FCT) through program
!   Ciencia 2007 funded by FCT/MCTES (Portugal) and POPH/FSE (EC), and in the
!   form of grants reference PTDC/CTE-AST/098528/2008, SFRH/BPD/71230/2010, and
!   SFRH/BPD/81084/2011.
!
!
!  History:                                                                
!*/
!/*-----------------------------------------------------------------*/

!/*----------------------------------------------------------------*/
!/* License of the file :
!
!    This program is free software: you can redistribute it and/or modify
!    it under the terms of the GNU General Public License as published by
!    the Free Software Foundation, either version 3 of the License, or
!    (at your option) any later version.
!
!    This program is distributed in the hope that it will be useful,
!    but WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!    GNU General Public License for more details.
!
!    You should have received a copy of the GNU General Public License
!    along with this program.  If not, see <http://www.gnu.org/licenses/>.
!*/
!/*----------------------------------------------------------------*/

       program main
       use module_arome

       implicit none
       integer, parameter :: ncoord = 20
       real(8) :: tab_flux_in(ncoord)
       real(8) :: tab_flux_out(ncoord)
       type(C_PTR) :: arome
       integer :: nerror
       integer :: k

       nerror = 0

       do k=1,ncoord
         tab_flux_in(k) = cos(1.0d0*k)
       end do
       
       call arome_set_exit_on_error()

       !/* allocation of the ARoME structure */
       arome = arome_alloc_quad(0.6d0,0.0d0)
       
       !/* to use the vectorial routines, it is necessary to allocate the necessary space */
       nerror = arome_malloc(ncoord, arome)
       
       !/* set the flux */
       nerror = arome_mset_flux(tab_flux_in, ncoord, arome)

       !/* get the flux */
       nerror = arome_mget_flux(arome, ncoord, tab_flux_out)

       do k=1,ncoord
         if ( abs(tab_flux_in(k) - tab_flux_out(k)) .gt. 1.0d-10 ) then
            print '(A,I2,A,F20.15,A,I2,A,F20.15,A)', "ERROR: flux_out[",&
     &            k,"] (",tab_flux_out(k),") is not equal to Flux_in[", &
     &            k,"] (",tab_flux_in(k),")."
            stop 1
         end if
       end do
       
       !/* release memory */
       call arome_mfree(arome)
       call arome_free(arome)
       
       end program
