!/*-----------------------------------------------------------------*/
!/*! 
!  \file f2003error.f 
!  \brief Example of usage of the error handler functions using the fortran 2003 interface
!         This example generates errors.
!         In a first step, on error, it displays a custom message using 
!          its own subroutine.
!         In a second step, on error, the library displays the default error message 
!          but continues the execution.
!         In a last step, on error, the library displays the default error message 
!          but exits.
!         So the message "goodbye" is never displayed.
!
!  \author  G. Boue
!           EXOEarths, Centro de Astrofisica, Universidade do Porto.
!
!   Copyright (C) 2012, CAUP
!   email of the author : gwenael.boue@astro.up.pt
!
!
!   This work has been supported by the European Research Council/European
!   Community under the FP7 through Starting Grant agreement number 239953, as
!   well as from Fundacao para a Ciencia e a Tecnologia (FCT) through program
!   Ciencia 2007 funded by FCT/MCTES (Portugal) and POPH/FSE (EC), and in the
!   form of grants reference PTDC/CTE-AST/098528/2008, SFRH/BPD/71230/2010, and
!   SFRH/BPD/81084/2011.
!
!
!*/
!/*-----------------------------------------------------------------*/

!/*----------------------------------------------------------------*/
!/* License of the file :
!
!    This program is free software: you can redistribute it and/or modify
!    it under the terms of the GNU General Public License as published by
!    the Free Software Foundation, either version 3 of the License, or
!    (at your option) any later version.
!
!    This program is distributed in the hope that it will be useful,
!    but WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!    GNU General Public License for more details.
!
!    You should have received a copy of the GNU General Public License
!    along with this program.  If not, see <http://www.gnu.org/licenses/>.
!*/
!/*----------------------------------------------------------------*/


!/*-----------------------------------------------------------------*/
!/* custom error handler */
!/*-----------------------------------------------------------------*/
        subroutine myhandler(msg, msglen) BIND(C)
           USE, INTRINSIC :: ISO_C_BINDING
           implicit none
           character(kind=C_CHAR), dimension(msglen), intent(in)        &
     &                  :: msg
           integer(C_INT), VALUE, intent(in) :: msglen
           write (*,*) "The ARoME calls the function myhandler"
           write (*,*) "The message contains ",msglen," characters"
           write(*,*) "The error message is :"
           write(*,*) "----------------------"
           write(*,*) msg
           write(*,*) "----------------------"
           write(*,*) "The error handler returns"
        end

!/*-----------------------------------------------------------------*/
!/* main program */
!/*-----------------------------------------------------------------*/
       program f2003error
           USE, INTRINSIC :: ISO_C_BINDING
           use module_arome
           implicit none
           type(C_PTR) arome
           real(8) flux
           
           interface
            subroutine myhandler(msg, msglen) BIND(C)
                USE, INTRINSIC :: ISO_C_BINDING
                implicit none
                character(kind=C_CHAR), dimension(msglen), intent(in)   &
     &                  :: msg
                integer(C_INT), VALUE, intent(in) :: msglen
            end subroutine
           end interface 

           write (*,*) "Step 1 :"
           write (*,*) "it displays a custom message "
           write (*,*) "using its own subroutine"
           write (*,*) "This subroutine has an explicit interface"
           write (*,*) "(see at line 52-60 in the f2003error.f)"
! set the  error handler to use my own callback 
           call arome_set_func_on_error(c_funloc(myhandler))
! call without initialization
           flux = arome_get_flux(arome)
            
           write (*,*) 
           write (*,*) 
           write (*,*) "Step 2 :"
           write (*,*) "ARoME library displays the message "
           write (*,*) "but it continues"
! set the error handler to display error and continue
           call arome_set_continue_on_error()
! call without initialization
           flux = arome_get_flux(arome)
            
           write (*,*) 
           write (*,*) 
           write (*,*) "Step 3 :"
           write (*,*) "ARoME library displays the message "
           write (*,*) "but the programs exits"
! set the  error handler to stop on error
           call arome_set_exit_on_error()
! call without initialization
           flux = arome_get_flux(arome)

           write (*,*) "Goodbye"
           write (*,*) "If you see this message, you find a bug !"
       stop
       end
      
