/*-----------------------------------------------------------------*/
/*! 
  \file cerror.c 
  \brief Example of usage of the error handler functions with the C interface
         This example generates errors.
         In a first step, on error, it displays a custom message using 
          its own subroutine.
         In a second step, on error, the library displays the default error message 
          but continues the execution.
         In a last step, on error, the library displays the default error message 
          but exits.
         So the message "goodbye" is never displayed.


  \author  G. Boue
           EXOEarths, Centro de Astrofisica, Universidade do Porto.

   Copyright (C) 2012, CAUP
   email of the author : gwenael.boue@astro.up.pt

   This work has been supported by the European Research Council/European
   Community under the FP7 through Starting Grant agreement number 239953, as
   well as from Fundacao para a Ciencia e a Tecnologia (FCT) through program
   Ciencia 2007 funded by FCT/MCTES (Portugal) and POPH/FSE (EC), and in the
   form of grants reference PTDC/CTE-AST/098528/2008, SFRH/BPD/71230/2010, and
   SFRH/BPD/81084/2011.


  History:                                                                
*/
/*-----------------------------------------------------------------*/

/*----------------------------------------------------------------*/
/* License of the file :

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
/*----------------------------------------------------------------*/
#include <stdio.h>
#include <string.h>
#include "arome.h"


/*-----------------------------------------------------------------*/
/* custom error handler */
/*-----------------------------------------------------------------*/
void 
myhandler(const char *msg)
{
	puts("The ARoME calls the function myhandler");
	printf("The message contains %d characters\n", (int)strlen(msg));
	puts("The error message is :");
	puts("----------------------");
	puts(msg);
	puts("----------------------");
	puts("The error handler returns");
}

/*-----------------------------------------------------------------*/
/* main program */
/*-----------------------------------------------------------------*/
int main(int argc, char **argv)
{
   t_arome *arome = NULL;
   double flux = 0.0;

	puts("Step 1 :");
	puts("it displays a custom message using its own subroutine\n");
	/* set the  error handler to use my own callback */
	arome_set_func_on_error(myhandler);
	/* call without initialization */
	flux = arome_get_flux(arome);

	puts("\n\nStep 2 :");
	puts("ARoME library displays the message but it continues\n");
	/* set the error handler to display error and continue */
	arome_set_continue_on_error();
	/* call without initialization */
	flux = arome_get_flux(arome);

	puts("\n\nStep 3 :");
	puts("ARoME library displays the message but the programs exits\n");
	/* set the  error handler to stop on error */
	arome_set_exit_on_error();
	/* call without initialization */
	flux = arome_get_flux(arome);

	puts("Goodbye\n");
	puts("If you see this message, you find a bug !\n");

	return (flux==flux);
}
